from message import Msg

ENCODE = {'A': '.-',     'B': '-...',   'C': '-.-.',
        'D': '-..',    'E': '.',      'F': '..-.',
        'G': '--.',    'H': '....',   'I': '..',
        'J': '.---',   'K': '-.-',    'L': '.-..',
        'M': '--',     'N': '-.',     'O': '---',
        'P': '.--.',   'Q': '--.-',   'R': '.-.',
        'S': '...',    'T': '-',      'U': '..-',
        'V': '...-',   'W': '.--',    'X': '-..-',
        'Y': '-.--',   'Z': '--..',

        '0': '-----',  '1': '.----',  '2': '..---',
        '3': '...--',  '4': '....-',  '5': '.....',
        '6': '-....',  '7': '--...',  '8': '---..',
        '9': '----.'
}

DECODE = {}

class Processor:
    def __init__(self):
        for key in ENCODE:
            DECODE[ENCODE[key]] = key

    def encode(self, msg):
        morze = ''
        for ch in msg.text:
            morze += ENCODE[ch.upper()]
        return morze

    def decode(self, msg):
        text = ''
        for ch in msg.text:
            text += DECODE[ch.upper()]
        return text

    def process(self, msg):
        if msg.encode:
            return self.encode(msg)
        else:
            return self.decode(msg)